/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.tools;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.File;
import java.io.IOException;
import net.coobird.thumbnailator.Thumbnails;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.site.FileComponent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ThumbDirective
extends AbstractTemplateDirective {
    @Autowired
    private FileComponent fileComponent;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        String path = handler.getString("path");
        Integer width = handler.getInteger("width");
        Integer height = handler.getInteger("height");
        SysSite site = this.getSite(handler);
        if (CommonUtils.notEmpty(path) && CommonUtils.notEmpty(width) && CommonUtils.notEmpty(height)) {
            String thumbPath = path.substring(0, path.lastIndexOf(".")) + "_" + width + "_" + height + this.fileComponent.getSuffix(path);
            File thumbFile = new File(this.siteComponent.getWebFilePath(site, thumbPath));
            thumbPath = site.getSitePath() + thumbPath;
            if (thumbFile.exists()) {
                handler.print(thumbPath);
            } else {
                try {
                    Thumbnails.of((String[])new String[]{this.siteComponent.getWebFilePath(site, path)}).size(width.intValue(), height.intValue()).toFile(thumbFile);
                    thumbFile.setReadable(true, false);
                    thumbFile.setWritable(true, false);
                    handler.print(thumbPath);
                }
                catch (IOException e) {
                    handler.print(site.getSitePath() + path);
                    this.log.error((Object)e.getMessage());
                }
            }
        }
    }

    @Override
    public boolean needAppToken() {
        return true;
    }
}

