/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.tools;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.template.MetadataComponent;
import org.publiccms.logic.component.template.TemplateComponent;
import org.publiccms.views.pojo.CmsPlaceMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IncludePlaceDirective
extends AbstractTemplateDirective {
    private static ExecutorService pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    @Autowired
    private TemplateComponent templateComponent;
    @Autowired
    private MetadataComponent metadataComponent;

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        String path = handler.getString("path");
        Object[] paths = handler.getStringArray("paths");
        if (CommonUtils.notEmpty(path)) {
            SysSite site = this.getSite(handler);
            CmsPlaceMetadata metadata = this.metadataComponent.getPlaceMetadata(this.siteComponent.getWebTemplateFilePath(site, TemplateComponent.INCLUDE_DIRECTORY + path));
            if (site.isUseSsi()) {
                handler.print("<!--#include virtual=\"/" + TemplateComponent.INCLUDE_DIRECTORY + path + "\"-->");
            } else {
                this.templateComponent.printPlace(handler.getWriter(), site, path, metadata);
            }
        } else if (CommonUtils.notEmpty(paths)) {
            SysSite site = this.getSite(handler);
            ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
            if (site.isUseSsi()) {
                void var8_13;
                Object[] objectArray = paths;
                int n = objectArray.length;
                boolean bl = false;
                while (var8_13 < n) {
                    Object p = objectArray[var8_13];
                    map.put((String)p, "<!--#include virtual=\"/" + TemplateComponent.INCLUDE_DIRECTORY + (String)p + "\"-->");
                    ++var8_13;
                }
                handler.put("map", map).render();
            } else {
                HashSet<Object> set = new HashSet<Object>();
                for (Object p : paths) {
                    set.add(p);
                }
                for (String string : set) {
                    pool.execute(new RanderTask(string, set.size(), map, this.getSite(handler), handler));
                }
                handler.setRenderd();
            }
        }
    }

    @Override
    public boolean needAppToken() {
        return true;
    }

    class RanderTask
    implements Runnable {
        private String path;
        private int count;
        private Map<String, String> resultMap;
        private SysSite site;
        private RenderHandler handler;

        public RanderTask(String path, int count, Map<String, String> resultMap, SysSite site, RenderHandler handler) {
            this.path = path;
            this.count = count;
            this.resultMap = resultMap;
            this.site = site;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CmsPlaceMetadata metadata = IncludePlaceDirective.this.metadataComponent.getPlaceMetadata(IncludePlaceDirective.this.siteComponent.getWebTemplateFilePath(this.site, TemplateComponent.INCLUDE_DIRECTORY + this.path));
            try {
                this.resultMap.put(this.path, IncludePlaceDirective.this.templateComponent.printPlace(this.site, this.path, metadata));
            }
            catch (TemplateException | IOException e) {
                IncludePlaceDirective.this.log.error((Object)e);
                this.resultMap.put(this.path, e.getMessage());
            }
            RanderTask randerTask = this;
            synchronized (randerTask) {
                if (this.resultMap.size() >= this.count) {
                    try {
                        this.handler.put("map", this.resultMap).render();
                    }
                    catch (Exception e) {
                        IncludePlaceDirective.this.log.error((Object)e.getMessage());
                    }
                }
            }
        }
    }
}

