/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.tools;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.site.SiteComponent;
import org.publiccms.logic.component.template.TemplateComponent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateTemplateFileDirective
extends AbstractTemplateDirective {
    @Autowired
    private TemplateComponent templateComponent;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        String templatePath = handler.getString("templatePath");
        String filePath = handler.getString("filePath");
        Integer pageIndex = handler.getInteger("pageIndex");
        if (CommonUtils.notEmpty(templatePath) && CommonUtils.notEmpty(filePath)) {
            SysSite site = this.getSite(handler);
            String templateFullPath = SiteComponent.getFullFileName(site, templatePath);
            try {
                handler.put("url", this.templateComponent.createStaticFile(site, templateFullPath, filePath, pageIndex, null, null)).render();
            }
            catch (TemplateException | IOException e) {
                handler.print(e.getMessage());
            }
        }
    }

    @Override
    public boolean needAppToken() {
        return true;
    }
}

