/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.tools;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.entities.cms.CmsCategory;
import org.publiccms.entities.cms.CmsContent;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.site.SiteComponent;
import org.publiccms.logic.component.template.TemplateComponent;
import org.publiccms.logic.service.cms.CmsCategoryService;
import org.publiccms.logic.service.cms.CmsContentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateContentFileDirective
extends AbstractTemplateDirective {
    @Autowired
    private TemplateComponent templateComponent;
    @Autowired
    private CmsCategoryService categoryService;
    @Autowired
    private CmsContentService contentService;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        Long id = handler.getLong("id");
        String templatePath = handler.getString("templatePath");
        String filePath = handler.getString("filePath");
        Integer pageIndex = handler.getInteger("pageIndex");
        if (CommonUtils.notEmpty(id) && CommonUtils.notEmpty(templatePath) && CommonUtils.notEmpty(filePath)) {
            SysSite site = this.getSite(handler);
            String templateFullPath = SiteComponent.getFullFileName(site, templatePath);
            try {
                CmsContent content = (CmsContent)this.contentService.getEntity(id);
                if (null != content && site.getId().intValue() == content.getSiteId()) {
                    CmsCategory category = (CmsCategory)this.categoryService.getEntity(Integer.valueOf(content.getCategoryId()));
                    handler.put("url", this.templateComponent.createContentFile(site, content, category, false, templateFullPath, filePath, pageIndex)).render();
                }
            }
            catch (TemplateException | IOException e) {
                handler.print(e.getMessage());
            }
        }
    }

    @Override
    public boolean needAppToken() {
        return true;
    }
}

