/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.task;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.publiccms.common.base.AbstractTaskDirective;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.site.FileComponent;
import org.publiccms.logic.component.site.SiteComponent;
import org.publiccms.logic.component.template.MetadataComponent;
import org.publiccms.logic.component.template.TemplateComponent;
import org.publiccms.views.pojo.CmsPageMetadata;
import org.publiccms.views.pojo.CmsPlaceMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PublishPageDirective
extends AbstractTaskDirective {
    @Autowired
    private FileComponent fileComponent;
    @Autowired
    private TemplateComponent templateComponent;
    @Autowired
    private MetadataComponent metadataComponent;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        String path = handler.getString("path", "/");
        List<FileComponent.FileInfo> list = this.fileComponent.getFileList(this.siteComponent.getWebTemplateFilePath(this.getSite(handler), path));
        handler.put("map", this.deal(this.getSite(handler), path, list)).render();
    }

    private Map<String, Boolean> deal(SysSite site, String path, List<FileComponent.FileInfo> list) {
        path = path.replace("\\", "/").replace("//", "/");
        Map<String, CmsPageMetadata> metadataMap = this.metadataComponent.getTemplateMetadataMap(this.siteComponent.getWebTemplateFilePath(site, path));
        LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
        for (FileComponent.FileInfo fileInfo : list) {
            CmsPageMetadata metadata;
            String filePath = path + fileInfo.getFileName();
            if (fileInfo.isDirectory()) {
                map.putAll(this.deal(site, filePath + "/", this.fileComponent.getFileList(this.siteComponent.getWebTemplateFilePath(site, filePath))));
                continue;
            }
            if (site.isUseSsi()) {
                String placesPath = TemplateComponent.INCLUDE_DIRECTORY + filePath + "/";
                map.putAll(this.dealPlace(site, filePath + "/", this.metadataComponent.getPlaceMetadataMap(this.siteComponent.getWebTemplateFilePath(site, placesPath)), this.fileComponent.getFileList(this.siteComponent.getWebTemplateFilePath(site, placesPath))));
            }
            if (null == (metadata = metadataMap.get(fileInfo.getFileName())) || !CommonUtils.notEmpty(metadata.getPublishPath())) continue;
            try {
                this.templateComponent.createStaticFile(site, SiteComponent.getFullFileName(site, filePath), metadata.getPublishPath(), null, metadata, null);
                map.put(filePath, true);
            }
            catch (TemplateException | IOException e) {
                map.put(filePath, false);
            }
        }
        return map;
    }

    private Map<String, Boolean> dealPlace(SysSite site, String path, Map<String, CmsPlaceMetadata> metadataMap, List<FileComponent.FileInfo> fileList) {
        LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
        for (FileComponent.FileInfo fileInfo : fileList) {
            String filePath = path + fileInfo.getFileName();
            try {
                CmsPlaceMetadata metadata = metadataMap.get(fileInfo.getFileName());
                if (null == metadata) {
                    metadata = new CmsPlaceMetadata();
                }
                this.templateComponent.staticPlace(site, filePath, metadata);
                map.put(filePath, true);
            }
            catch (TemplateException | IOException e) {
                map.put(filePath, false);
            }
        }
        return map;
    }
}

