/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.task;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import org.publiccms.common.base.AbstractTaskDirective;
import org.publiccms.entities.cms.CmsContent;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.template.TemplateComponent;
import org.publiccms.logic.service.cms.CmsContentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PublishContentDirective
extends AbstractTaskDirective {
    @Autowired
    private TemplateComponent templateComponent;
    @Autowired
    private CmsContentService service;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        Long id = handler.getLong("id");
        SysSite site = this.getSite(handler);
        LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
        if (CommonUtils.notEmpty(id)) {
            map.put(id.toString(), this.templateComponent.createContentFile(site, (CmsContent)this.service.getEntity(id), null, null));
        } else {
            Object[] ids = handler.getLongArray("ids");
            if (CommonUtils.notEmpty(ids)) {
                List entityList = this.service.getEntitys((Serializable[])ids);
                for (CmsContent entity : entityList) {
                    map.put(entity.getId().toString(), this.templateComponent.createContentFile(site, entity, null, null));
                }
            }
        }
        handler.put("map", map).render();
    }
}

