/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.task;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import org.publiccms.common.base.AbstractTaskDirective;
import org.publiccms.entities.cms.CmsCategory;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.template.TemplateComponent;
import org.publiccms.logic.service.cms.CmsCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PublishCategoryDirective
extends AbstractTaskDirective {
    @Autowired
    private TemplateComponent templateComponent;
    @Autowired
    private CmsCategoryService service;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        Integer id = handler.getInteger("id");
        Integer pageIndex = handler.getInteger("pageIndex");
        Integer totalPage = handler.getInteger("totalPage");
        SysSite site = this.getSite(handler);
        LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
        if (CommonUtils.notEmpty(id)) {
            CmsCategory entity = (CmsCategory)this.service.getEntity(id);
            map.put(entity.getId().toString(), this.deal(site, entity, pageIndex, totalPage));
        } else {
            Object[] ids = handler.getIntegerArray("ids");
            if (CommonUtils.notEmpty(ids)) {
                List entityList = this.service.getEntitys((Serializable[])ids);
                for (CmsCategory entity : entityList) {
                    map.put(entity.getId().toString(), this.deal(site, entity, pageIndex, totalPage));
                }
            }
        }
        handler.put("map", map).render();
    }

    private boolean deal(SysSite site, CmsCategory entity, Integer pageIndex, Integer totalPage) {
        if (null != entity) {
            return this.templateComponent.createCategoryFile(site, entity, pageIndex, totalPage);
        }
        return false;
    }
}

