/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.task;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.time.DateUtils;
import org.publiccms.common.base.AbstractTaskDirective;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.service.log.LogLoginService;
import org.publiccms.logic.service.log.LogOperateService;
import org.publiccms.logic.service.log.LogTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClearLogDirective
extends AbstractTaskDirective {
    @Autowired
    private LogLoginService logLoginService;
    @Autowired
    private LogOperateService logOperateService;
    @Autowired
    private LogTaskService logTaskService;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        Date date = handler.getDate("clearDate");
        if (CommonUtils.empty(date)) {
            date = DateUtils.addMonths((Date)CommonUtils.getDate(), (int)-3);
        }
        SysSite site = this.getSite(handler);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("loginLog:", this.logLoginService.delete(site.getId(), date));
        map.put("operateLog:", this.logOperateService.delete(site.getId(), date));
        map.put("taskLog:", this.logTaskService.delete(site.getId(), date));
        handler.put("result", map).render();
    }
}

