/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.sys;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.entities.sys.SysRoleMoudle;
import org.publiccms.logic.service.sys.SysRoleMoudleService;
import org.publiccms.logic.service.sys.SysRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysRoleMoudleDirective
extends AbstractTemplateDirective {
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private SysRoleMoudleService service;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        Object[] roleIds = handler.getIntegerArray("roleIds");
        Integer moudleId = handler.getInteger("moudleId");
        if (CommonUtils.notEmpty(roleIds)) {
            if (CommonUtils.notEmpty(moudleId)) {
                SysRoleMoudle entity = this.service.getEntity((Integer[])roleIds, moudleId);
                handler.put("object", entity).render();
            } else {
                Object[] moudleIds = handler.getIntegerArray("moudleIds");
                if (CommonUtils.notEmpty(moudleIds)) {
                    LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
                    if (this.sysRoleService.showAllMoudle((Integer[])roleIds)) {
                        for (Object id : moudleIds) {
                            map.put(String.valueOf(id), true);
                        }
                    } else {
                        for (SysRoleMoudle entity : this.service.getEntitys((Integer[])roleIds, (Integer[])moudleIds)) {
                            map.put(String.valueOf(entity.getId().getMoudleId()), true);
                        }
                    }
                    handler.put("map", map).render();
                }
            }
        }
    }

    @Override
    public boolean needAppToken() {
        return true;
    }
}

