/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.sys;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.entities.sys.SysDept;
import org.publiccms.entities.sys.SysDeptPage;
import org.publiccms.entities.sys.SysDeptPageId;
import org.publiccms.logic.service.sys.SysDeptPageService;
import org.publiccms.logic.service.sys.SysDeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysDeptPageDirective
extends AbstractTemplateDirective {
    @Autowired
    private SysDeptPageService service;
    @Autowired
    private SysDeptService sysDeptService;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        Integer deptId = handler.getInteger("deptId");
        String page = handler.getString("page");
        if (CommonUtils.notEmpty(deptId)) {
            if (CommonUtils.notEmpty(page)) {
                SysDeptPage entity = (SysDeptPage)this.service.getEntity(deptId, page);
                handler.put("object", entity).render();
            } else {
                Object[] pages = handler.getStringArray("pages");
                if (CommonUtils.notEmpty(pages)) {
                    LinkedHashMap<Object, Boolean> map = new LinkedHashMap<Object, Boolean>();
                    SysDept entity = (SysDept)this.sysDeptService.getEntity(deptId);
                    if (null != entity && entity.isOwnsAllPage()) {
                        for (Object p : pages) {
                            map.put(p, true);
                        }
                    } else {
                        Serializable[] ids = new SysDeptPageId[pages.length];
                        for (int i = 0; i < pages.length; ++i) {
                            map.put(pages[i], false);
                            ids[i] = new SysDeptPageId(deptId, (String)pages[i]);
                        }
                        for (SysDeptPage e : this.service.getEntitys(ids)) {
                            map.put(e.getId().getPage(), true);
                        }
                    }
                    handler.put("map", map).render();
                }
            }
        }
    }

    @Override
    public boolean needAppToken() {
        return true;
    }
}

