/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.sys;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.entities.sys.SysDept;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.service.sys.SysDeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysDeptDirective
extends AbstractTemplateDirective {
    @Autowired
    private SysDeptService service;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        Integer id = handler.getInteger("id");
        SysSite site = this.getSite(handler);
        if (CommonUtils.notEmpty(id)) {
            SysDept entity = (SysDept)this.service.getEntity(id);
            if (null != entity && site.getId().intValue() == entity.getSiteId()) {
                handler.put("object", entity).render();
            }
        } else {
            Object[] ids = handler.getIntegerArray("ids");
            if (CommonUtils.notEmpty(ids)) {
                List entityList = this.service.getEntitys((Serializable[])ids);
                LinkedHashMap<String, SysDept> map = new LinkedHashMap<String, SysDept>();
                for (SysDept entity : entityList) {
                    if (site.getId().intValue() != entity.getSiteId()) continue;
                    map.put(String.valueOf(entity.getId()), entity);
                }
                handler.put("map", map).render();
            }
        }
    }

    @Override
    public boolean needAppToken() {
        return true;
    }
}

