/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.sys;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.entities.sys.SysDept;
import org.publiccms.entities.sys.SysDeptCategory;
import org.publiccms.entities.sys.SysDeptCategoryId;
import org.publiccms.logic.service.sys.SysDeptCategoryService;
import org.publiccms.logic.service.sys.SysDeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysDeptCategoryDirective
extends AbstractTemplateDirective {
    @Autowired
    private SysDeptCategoryService service;
    @Autowired
    private SysDeptService sysDeptService;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        Integer deptId = handler.getInteger("deptId");
        Integer categoryId = handler.getInteger("categoryId");
        if (CommonUtils.notEmpty(deptId)) {
            if (CommonUtils.notEmpty(categoryId)) {
                SysDept entity = (SysDept)this.sysDeptService.getEntity(deptId);
                if (null != entity) {
                    if (entity.isOwnsAllCategory()) {
                        handler.put("object", true).render();
                    } else {
                        handler.put("object", null != this.service.getEntity(new SysDeptCategoryId(deptId, categoryId))).render();
                    }
                }
            } else {
                Object[] categoryIds = handler.getIntegerArray("categoryIds");
                if (CommonUtils.notEmpty(categoryIds)) {
                    LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
                    SysDept entity = (SysDept)this.sysDeptService.getEntity(deptId);
                    if (null != entity) {
                        if (entity.isOwnsAllCategory()) {
                            for (Object id : categoryIds) {
                                map.put(String.valueOf(id), true);
                            }
                        } else {
                            Serializable[] ids = new SysDeptCategoryId[categoryIds.length];
                            for (int i = 0; i < categoryIds.length; ++i) {
                                map.put(String.valueOf(categoryIds[i]), false);
                                ids[i] = new SysDeptCategoryId(deptId, (Integer)categoryIds[i]);
                            }
                            for (SysDeptCategory e : this.service.getEntitys(ids)) {
                                map.put(String.valueOf(e.getId().getCategoryId()), true);
                            }
                        }
                    }
                    handler.put("map", map).render();
                }
            }
        }
    }

    @Override
    public boolean needAppToken() {
        return true;
    }
}

