/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.sys;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.common.tools.ExtendUtils;
import org.publiccms.entities.sys.SysConfigData;
import org.publiccms.entities.sys.SysConfigDataId;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.service.sys.SysConfigDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysConfigDataDirective
extends AbstractTemplateDirective {
    @Autowired
    private SysConfigDataService service;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        String code = handler.getString("code");
        Object[] codes = handler.getStringArray("codes");
        SysSite site = this.getSite(handler);
        if (CommonUtils.notEmpty(code)) {
            SysConfigData entity = (SysConfigData)this.service.getEntity(new SysConfigDataId(site.getId(), code));
            if (null != entity) {
                handler.put("object", ExtendUtils.getExtendMap(entity.getData())).render();
            }
        } else if (CommonUtils.notEmpty(codes)) {
            Serializable[] ids = new SysConfigDataId[codes.length];
            int i = 0;
            for (Object s : codes) {
                if (!CommonUtils.notEmpty((String)s)) continue;
                ids[i++] = new SysConfigDataId(site.getId(), (String)s);
            }
            HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
            for (SysConfigData entity : this.service.getEntitys(ids)) {
                map.put(entity.getId().getCode(), ExtendUtils.getExtendMap(entity.getData()));
            }
            handler.put("map", map).render();
        }
    }
}

