/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.sys;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.io.IOException;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.entities.sys.SysAppClient;
import org.publiccms.entities.sys.SysAppClientId;
import org.publiccms.logic.service.sys.SysAppClientService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateAppClientDirective
extends AbstractTemplateDirective {
    @Autowired
    private SysAppClientService appClientService;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        String uuid = handler.getString("uuid");
        String channel = handler.getString("channel");
        Long userId = handler.getLong("userId");
        if (CommonUtils.notEmpty(uuid) && CommonUtils.notEmpty(channel)) {
            SysAppClientId sysAppClientId = new SysAppClientId(this.getSite(handler).getId(), channel, uuid);
            SysAppClient appClient = (SysAppClient)this.appClientService.getEntity(sysAppClientId);
            if (null == appClient) {
                appClient = new SysAppClient(sysAppClientId, CommonUtils.getDate(), false);
                appClient.setClientVersion(uuid);
                appClient.setLastLoginIp(RequestUtils.getIpAddress(handler.getRequest()));
                if (CommonUtils.notEmpty(userId)) {
                    appClient.setUserId(userId);
                }
                this.appClientService.save(appClient);
            } else {
                this.appClientService.updateLastLogin(sysAppClientId, uuid, RequestUtils.getIpAddress(handler.getRequest()));
                this.appClientService.updateUser(sysAppClientId, userId);
            }
            handler.render();
        }
    }

    @Override
    public boolean needAppToken() {
        return true;
    }
}

