/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.home;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.entities.home.HomeAttention;
import org.publiccms.entities.home.HomeAttentionId;
import org.publiccms.logic.service.home.HomeAttentionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HomeAttentionDirective
extends AbstractTemplateDirective {
    @Autowired
    private HomeAttentionService service;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        Long userId = handler.getLong("userId");
        Long attentionId = handler.getLong("attentionId");
        if (CommonUtils.notEmpty(userId) && CommonUtils.notEmpty(attentionId)) {
            handler.put("object", this.service.getEntity(new HomeAttentionId(userId, attentionId))).render();
        } else {
            Object[] userIds = handler.getLongArray("userIds");
            Object[] attentionIds = handler.getLongArray("attentionIds");
            if (CommonUtils.notEmpty(userId) && CommonUtils.notEmpty(attentionIds)) {
                Serializable[] ids = new HomeAttentionId[attentionIds.length];
                for (int i = 0; i < attentionIds.length; ++i) {
                    ids[i] = new HomeAttentionId(userId, (Long)attentionIds[i]);
                }
                List entityList = this.service.getEntitys(ids);
                LinkedHashMap<String, HomeAttention> map = new LinkedHashMap<String, HomeAttention>();
                for (HomeAttention entity : entityList) {
                    map.put(String.valueOf(entity.getId()), entity);
                }
                handler.put("map", map).render();
            } else if (CommonUtils.notEmpty(attentionId) && CommonUtils.notEmpty(userIds)) {
                Serializable[] ids = new HomeAttentionId[userIds.length];
                for (int i = 0; i < userIds.length; ++i) {
                    ids[i] = new HomeAttentionId((Long)userIds[i], attentionId);
                }
                List entityList = this.service.getEntitys(ids);
                LinkedHashMap<String, HomeAttention> map = new LinkedHashMap<String, HomeAttention>();
                for (HomeAttention entity : entityList) {
                    map.put(String.valueOf(entity.getId()), entity);
                }
                handler.put("map", map).render();
            }
        }
    }

    @Override
    public boolean needUserToken() {
        return true;
    }
}

