/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.cms;

import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import java.util.Date;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.logic.service.cms.CmsPlaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CmsPlaceListDirective
extends AbstractTemplateDirective {
    @Autowired
    private CmsPlaceService service;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        Date endPublishDate = handler.getDate("endPublishDate");
        String path = handler.getString("path");
        Boolean disabled = false;
        Integer status = 1;
        if (handler.getBoolean("advanced", false)) {
            status = handler.getInteger("status");
            disabled = handler.getBoolean("disabled", false);
        } else {
            Date now = CommonUtils.getMinuteDate();
            if (CommonUtils.empty(endPublishDate) || endPublishDate.after(now)) {
                endPublishDate = now;
            }
        }
        if (CommonUtils.notEmpty(path)) {
            path = path.replace("//", "/");
        }
        PageHandler page = this.service.getPage(this.getSite(handler).getId(), handler.getLong("userId"), path, handler.getString("itemType"), handler.getInteger("itemId"), handler.getDate("startPublishDate"), handler.getDate("endPublishDate"), status, disabled, handler.getString("orderField"), handler.getString("orderType"), handler.getInteger("pageIndex", 1), handler.getInteger("count", 30));
        handler.put("page", page).render();
    }
}

