/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.cms;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.template.ModelComponent;
import org.publiccms.views.pojo.CmsModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CmsModelDirective
extends AbstractTemplateDirective {
    @Autowired
    private ModelComponent modelComponent;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        String id = handler.getString("id");
        SysSite site = this.getSite(handler);
        if (CommonUtils.notEmpty(id)) {
            CmsModel entity = this.modelComponent.getMap(site).get(id);
            if (null != entity) {
                handler.put("object", entity).render();
            }
        } else {
            Object[] ids = handler.getStringArray("ids");
            if (CommonUtils.notEmpty(ids)) {
                Map<String, CmsModel> modelMap = this.modelComponent.getMap(site);
                LinkedHashMap<Object, CmsModel> map = new LinkedHashMap<Object, CmsModel>();
                for (Object modelId : ids) {
                    map.put(modelId, modelMap.get(modelId));
                }
                handler.put("map", map).render();
            }
        }
    }
}

