/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.cms;

import com.publiccms.common.handler.FacetPageHandler;
import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.site.StatisticsComponent;
import org.publiccms.logic.service.cms.CmsContentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CmsFacetSearchDirective
extends AbstractTemplateDirective {
    @Autowired
    private StatisticsComponent statisticsComponent;
    @Autowired
    private CmsContentService service;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        String word = handler.getString("word");
        String tagId = handler.getString("tagId");
        if (CommonUtils.notEmpty(word) || CommonUtils.notEmpty(tagId)) {
            FacetPageHandler page;
            Object[] tagIds;
            SysSite site = this.getSite(handler);
            if (CommonUtils.notEmpty(word)) {
                this.statisticsComponent.search(site.getId(), word);
            }
            if (CommonUtils.notEmpty(tagIds = handler.getStringArray("tagId"))) {
                for (Object id : tagIds) {
                    try {
                        this.statisticsComponent.searchTag(Long.parseLong((String)id));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            Integer pageIndex = handler.getInteger("pageIndex", 1);
            Integer count = handler.getInteger("count", 30);
            try {
                page = this.service.facetQuery(site.getId(), handler.getStringArray("categoryId"), handler.getStringArray("modelId"), handler.getStringArray("userId"), word, tagId, pageIndex, count);
            }
            catch (Exception e) {
                page = new FacetPageHandler(pageIndex, count, 0, null);
            }
            handler.put("page", page).render();
        }
    }
}

