/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.cms;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.entities.cms.CmsDictionaryData;
import org.publiccms.entities.cms.CmsDictionaryDataId;
import org.publiccms.logic.service.cms.CmsDictionaryDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CmsDictionaryDataDirective
extends AbstractTemplateDirective {
    @Autowired
    private CmsDictionaryDataService service;

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        Long dictionaryId = handler.getLong("dictionaryId");
        String value = handler.getString("value");
        if (CommonUtils.notEmpty(dictionaryId)) {
            if (CommonUtils.notEmpty(value)) {
                CmsDictionaryData entity = (CmsDictionaryData)this.service.getEntity(new CmsDictionaryDataId(dictionaryId, value));
                handler.put("object", entity).render();
            } else {
                Object[] values = handler.getStringArray("values");
                if (CommonUtils.notEmpty(values)) {
                    LinkedHashMap<String, CmsDictionaryData> map = new LinkedHashMap<String, CmsDictionaryData>();
                    Serializable[] ids = new CmsDictionaryDataId[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        ids[i] = new CmsDictionaryDataId(dictionaryId, (String)values[i]);
                    }
                    for (CmsDictionaryData entity : this.service.getEntitys(ids)) {
                        map.put(entity.getId().getValue(), entity);
                    }
                    handler.put("map", map).render();
                }
            }
        }
    }
}

