/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.api;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.io.IOException;
import org.publiccms.common.base.AbstractAppDirective;
import org.publiccms.entities.cms.CmsVote;
import org.publiccms.entities.cms.CmsVoteUser;
import org.publiccms.entities.sys.SysApp;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.logic.service.cms.CmsVoteService;
import org.publiccms.logic.service.cms.CmsVoteUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class VoteDirective
extends AbstractAppDirective {
    @Autowired
    private CmsVoteService voteService;
    @Autowired
    private CmsVoteUserService voteUserService;

    @Override
    public void execute(RenderHandler handler, SysApp app, SysUser user) throws IOException, Exception {
        Integer voteId = handler.getInteger("voteId");
        Object[] itemIds = handler.getStringArray("itemIds");
        CmsVote vote = (CmsVote)this.voteService.getEntity(voteId);
        if (CommonUtils.notEmpty(vote) && CommonUtils.notEmpty(itemIds) && !vote.isDisabled()) {
            CmsVoteUser entity = new CmsVoteUser(voteId, user.getId(), StringUtils.arrayToCommaDelimitedString((Object[])itemIds), RequestUtils.getIpAddress(handler.getRequest()), CommonUtils.getDate());
            this.voteUserService.save(entity);
        }
    }

    @Override
    public boolean needUserToken() {
        return true;
    }

    @Override
    public boolean needAppToken() {
        return false;
    }
}

