/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.api;

import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import org.publiccms.common.base.AbstractAppDirective;
import org.publiccms.entities.cms.CmsLottery;
import org.publiccms.entities.sys.SysApp;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.logic.service.cms.CmsLotteryService;
import org.publiccms.logic.service.cms.CmsLotteryUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LotteryStatusDirective
extends AbstractAppDirective {
    @Autowired
    private CmsLotteryUserService lotteryUserService;
    @Autowired
    private CmsLotteryService lotteryService;

    @Override
    public void execute(RenderHandler handler, SysApp app, SysUser user) throws IOException, Exception {
        Long lotteryId = handler.getLong("lotteryId");
        CmsLottery lottery = (CmsLottery)this.lotteryService.getEntity(lotteryId);
        SysSite site = this.getSite(handler);
        if (CommonUtils.notEmpty(lottery) && site.getId().intValue() == lottery.getSiteId() && !lottery.isDisabled()) {
            if (this.lotteryUserService.getPage(lotteryId, user.getId(), true, null, null, null, null, null).getTotalCount() == 0) {
                handler.put("winning", false);
                PageHandler page = this.lotteryUserService.getPage(lotteryId, user.getId(), null, null, null, null, null, null);
                handler.put("lastCount", lottery.getLotteryCount() - page.getTotalCount());
            } else {
                handler.put("winning", true);
            }
        } else {
            handler.put("error", true);
        }
    }

    @Override
    public boolean needUserToken() {
        return true;
    }

    @Override
    public boolean needAppToken() {
        return false;
    }
}

