/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.api;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.io.IOException;
import org.publiccms.common.base.AbstractAppDirective;
import org.publiccms.entities.cms.CmsLottery;
import org.publiccms.entities.cms.CmsLotteryUser;
import org.publiccms.entities.sys.SysApp;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.logic.service.cms.CmsLotteryService;
import org.publiccms.logic.service.cms.CmsLotteryUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LotteryDirective
extends AbstractAppDirective {
    @Autowired
    private CmsLotteryUserService lotteryUserService;
    @Autowired
    private CmsLotteryService lotteryService;

    @Override
    public void execute(RenderHandler handler, SysApp app, SysUser user) throws IOException, Exception {
        Long lotteryId = handler.getLong("lotteryId");
        CmsLottery lottery = (CmsLottery)this.lotteryService.getEntity(lotteryId);
        SysSite site = this.getSite(handler);
        if (CommonUtils.notEmpty(lottery) && site.getId().intValue() == lottery.getSiteId() && !lottery.isDisabled() && this.lotteryUserService.getPage(lotteryId, user.getId(), true, null, null, null, null, null).getTotalCount() == 0 && lottery.getLotteryCount() - this.lotteryUserService.getPage(lotteryId, user.getId(), null, null, null, null, null, null).getTotalCount() > 0) {
            CmsLotteryUser entity = new CmsLotteryUser(lotteryId, user.getId(), false, false, RequestUtils.getIpAddress(handler.getRequest()), CommonUtils.getDate());
            entity.setUserId(user.getId());
            if (lottery.getFractions() > r.nextInt(lottery.getNumerator()) && lottery.getLastGift() > 0 && lottery.getLotteryCount() > this.lotteryUserService.getPage(lotteryId, null, true, null, null, null, null, null).getTotalCount()) {
                entity.setWinning(true);
            }
            this.lotteryUserService.save(entity);
            handler.put("result", "success");
            handler.put("winning", entity.isWinning());
        }
    }

    @Override
    public boolean needUserToken() {
        return true;
    }

    @Override
    public boolean needAppToken() {
        return false;
    }
}

