/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.api;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.RequestUtils;
import com.publiccms.common.tools.VerificationUtils;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.publiccms.common.base.AbstractAppDirective;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogLogin;
import org.publiccms.entities.sys.SysApp;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.entities.sys.SysUserToken;
import org.publiccms.logic.service.log.LogLoginService;
import org.publiccms.logic.service.sys.SysUserService;
import org.publiccms.logic.service.sys.SysUserTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoginDirective
extends AbstractAppDirective {
    @Autowired
    private SysUserService service;
    @Autowired
    private SysUserTokenService sysUserTokenService;
    @Autowired
    private LogLoginService logLoginService;

    @Override
    public void execute(RenderHandler handler, SysApp app, SysUser user) throws IOException, Exception {
        String username = StringUtils.trim((String)handler.getString("username"));
        String password = StringUtils.trim((String)handler.getString("password"));
        boolean result = false;
        if (CommonUtils.notEmpty(username) && CommonUtils.notEmpty(password)) {
            SysSite site = this.getSite(handler);
            user = AbstractController.verifyNotEMail(username) ? this.service.findByName(site.getId(), username) : this.service.findByEmail(site.getId(), username);
            String ip = RequestUtils.getIpAddress(handler.getRequest());
            if (null != user && user.getPassword().equals(VerificationUtils.encode(password))) {
                String authToken = UUID.randomUUID().toString();
                this.sysUserTokenService.save(new SysUserToken(authToken, site.getId(), user.getId(), app.getChannel(), CommonUtils.getDate(), ip));
                this.service.updateLoginStatus(user.getId(), ip);
                this.logLoginService.save(new LogLogin(site.getId(), username, user.getId(), ip, app.getChannel(), true, CommonUtils.getDate(), null));
                user.setPassword(null);
                result = true;
                handler.put("authToken", authToken).put("user", user);
            } else {
                LogLogin log = new LogLogin();
                log.setSiteId(site.getId());
                log.setName(username);
                log.setErrorPassword(password);
                log.setIp(ip);
                log.setChannel(app.getChannel());
                this.logLoginService.save(log);
            }
        }
        handler.put("result", result);
    }

    @Override
    public boolean needUserToken() {
        return false;
    }

    @Override
    public boolean needAppToken() {
        return true;
    }
}

