/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.api;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.io.IOException;
import java.util.UUID;
import org.publiccms.common.base.AbstractAppDirective;
import org.publiccms.entities.log.LogLogin;
import org.publiccms.entities.sys.SysApp;
import org.publiccms.entities.sys.SysAppClient;
import org.publiccms.entities.sys.SysAppClientId;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.entities.sys.SysUserToken;
import org.publiccms.logic.service.log.LogLoginService;
import org.publiccms.logic.service.sys.SysAppClientService;
import org.publiccms.logic.service.sys.SysUserService;
import org.publiccms.logic.service.sys.SysUserTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AutoLoginDirective
extends AbstractAppDirective {
    @Autowired
    private SysAppClientService appClientService;
    @Autowired
    private SysUserService service;
    @Autowired
    private SysUserTokenService sysUserTokenService;
    @Autowired
    private LogLoginService logLoginService;

    @Override
    public void execute(RenderHandler handler, SysApp app, SysUser user) throws IOException, Exception {
        SysSite site;
        SysAppClientId sysAppClientId;
        SysAppClient appClient;
        String uuid = handler.getString("uuid");
        boolean result = false;
        if (CommonUtils.notEmpty(uuid) && null != (appClient = (SysAppClient)this.appClientService.getEntity(sysAppClientId = new SysAppClientId((site = this.getSite(handler)).getId(), app.getChannel(), uuid))) && CommonUtils.notEmpty(appClient.getUserId()) && null != (user = (SysUser)this.service.getEntity(appClient.getUserId()))) {
            String authToken = UUID.randomUUID().toString();
            String ip = RequestUtils.getIpAddress(handler.getRequest());
            this.sysUserTokenService.save(new SysUserToken(authToken, site.getId(), user.getId(), app.getChannel(), CommonUtils.getDate(), ip));
            this.service.updateLoginStatus(user.getId(), ip);
            this.logLoginService.save(new LogLogin(site.getId(), uuid, user.getId(), ip, app.getChannel(), true, CommonUtils.getDate(), null));
            user.setPassword(null);
            result = true;
            handler.put("authToken", authToken).put("user", user);
        }
        handler.put("result", result);
    }

    @Override
    public boolean needUserToken() {
        return false;
    }

    @Override
    public boolean needAppToken() {
        return true;
    }
}

