/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.views.directive.api;

import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.io.IOException;
import org.publiccms.common.base.AbstractAppDirective;
import org.publiccms.entities.sys.SysApp;
import org.publiccms.entities.sys.SysAppClient;
import org.publiccms.entities.sys.SysAppClientId;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.logic.service.sys.SysAppClientService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppClientDirective
extends AbstractAppDirective {
    @Autowired
    private SysAppClientService appClientService;

    @Override
    public void execute(RenderHandler handler, SysApp app, SysUser user) throws IOException, Exception {
        String uuid = handler.getString("uuid");
        String clientVersion = handler.getString("clientVersion");
        if (CommonUtils.notEmpty(uuid)) {
            SysAppClientId sysAppClientId = new SysAppClientId(this.getSite(handler).getId(), app.getChannel(), uuid);
            SysAppClient appClient = (SysAppClient)this.appClientService.getEntity(sysAppClientId);
            if (null == appClient) {
                appClient = new SysAppClient(sysAppClientId, CommonUtils.getDate(), false);
                appClient.setClientVersion(clientVersion);
                appClient.setLastLoginIp(RequestUtils.getIpAddress(handler.getRequest()));
                this.appClientService.save(appClient);
            } else {
                this.appClientService.updateLastLogin(sysAppClientId, clientVersion, RequestUtils.getIpAddress(handler.getRequest()));
            }
        }
    }

    @Override
    public boolean needUserToken() {
        return false;
    }

    @Override
    public boolean needAppToken() {
        return true;
    }
}

