/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.sys;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.logic.dao.sys.SysUserDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysUserService
extends BaseService<SysUser> {
    @Autowired
    private SysUserDao dao;

    @Transactional(readOnly=true)
    public PageHandler getPage(Integer siteId, Integer deptId, Date startRegisteredDate, Date endRegisteredDate, Date startLastLoginDate, Date endLastLoginDate, Boolean superuserAccess, Boolean emailChecked, Boolean disabled, String name, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        return this.dao.getPage(siteId, deptId, startRegisteredDate, endRegisteredDate, startLastLoginDate, endLastLoginDate, superuserAccess, emailChecked, disabled, name, orderField, orderType, pageIndex, pageSize);
    }

    public SysUser findByName(int siteId, String name) {
        return this.dao.findByName(siteId, name);
    }

    public SysUser findByNickName(int siteId, String nickname) {
        return this.dao.findByNickName(siteId, nickname);
    }

    public SysUser findByEmail(int siteId, String email) {
        return this.dao.findByEmail(siteId, email);
    }

    public void updatePassword(Serializable id, String password) {
        SysUser entity = (SysUser)this.getEntity(id);
        if (null != entity) {
            entity.setPassword(password);
        }
    }

    public SysUser updateLoginStatus(Serializable id, String ip) {
        SysUser entity = (SysUser)this.getEntity(id);
        if (null != entity) {
            entity.setLastLoginDate(CommonUtils.getDate());
            entity.setLastLoginIp(ip);
            entity.setLoginCount(entity.getLoginCount() + 1);
        }
        return entity;
    }

    public void deleteRoleIds(Serializable userId, Integer roleId) {
        SysUser entity = (SysUser)this.getEntity(userId);
        if (null != entity) {
            String roles = entity.getRoles();
            Object[] roleArray = StringUtils.split((String)roles, (char)',');
            ArrayUtils.removeElement((Object[])roleArray, (Object)roleId.toString());
            entity.setRoles(org.springframework.util.StringUtils.arrayToCommaDelimitedString((Object[])roleArray));
        }
    }

    public void checked(Serializable id, String email) {
        SysUser entity = (SysUser)this.getEntity(id);
        if (null != entity) {
            entity.setEmail(email);
            entity.setEmailChecked(true);
        }
    }

    public SysUser updateStatus(Serializable id, boolean status) {
        SysUser entity = (SysUser)this.getEntity(id);
        if (null != entity) {
            entity.setDisabled(status);
        }
        return entity;
    }
}

