/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.sys;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.publiccms.entities.sys.SysRoleUser;
import org.publiccms.entities.sys.SysRoleUserId;
import org.publiccms.logic.dao.sys.SysRoleUserDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysRoleUserService
extends BaseService<SysRoleUser> {
    @Autowired
    private SysRoleUserDao dao;

    @Transactional(readOnly=true)
    public PageHandler getPage(Integer roleId, Long userId, Integer pageIndex, Integer pageSize) {
        return this.dao.getPage(roleId, userId, pageIndex, pageSize);
    }

    public void dealRoleUsers(Long userId, Integer[] roleIds) {
        List<?> list = this.getPage(null, userId, null, null).getList();
        if (CommonUtils.notEmpty(roleIds)) {
            for (SysRoleUser roleUser : list) {
                if (!ArrayUtils.contains((Object[])roleIds, (Object)roleUser.getId().getRoleId())) {
                    this.delete(roleUser.getId());
                }
                roleIds = (Integer[])ArrayUtils.removeElement((Object[])roleIds, (Object)roleUser.getId().getRoleId());
            }
            for (Integer roleId : roleIds) {
                this.save(new SysRoleUser(new SysRoleUserId(roleId, userId)));
            }
        } else {
            this.deleteByUserId(userId);
        }
    }

    public int deleteByUserId(Long userId) {
        return this.dao.deleteByUserId(userId);
    }

    public int deleteByRoleId(Integer roleId) {
        return this.dao.deleteByRoleId(roleId);
    }
}

