/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.sys;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.publiccms.entities.sys.SysRoleMoudle;
import org.publiccms.entities.sys.SysRoleMoudleId;
import org.publiccms.logic.dao.sys.SysRoleMoudleDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysRoleMoudleService
extends BaseService<SysRoleMoudle> {
    @Autowired
    private SysRoleMoudleDao dao;

    @Transactional(readOnly=true)
    public PageHandler getPage(Integer roleId, Integer moudleId, Integer pageIndex, Integer pageSize) {
        return this.dao.getPage(roleId, moudleId, pageIndex, pageSize);
    }

    public void updateRoleMoudles(Integer roleId, Integer[] moudleIds) {
        if (CommonUtils.notEmpty(roleId)) {
            List<?> list = this.getPage(roleId, null, null, null).getList();
            for (SysRoleMoudle roleMoudle : list) {
                if (ArrayUtils.contains((Object[])moudleIds, (Object)roleMoudle.getId().getMoudleId())) {
                    moudleIds = (Integer[])ArrayUtils.removeElement((Object[])moudleIds, (Object)roleMoudle.getId().getMoudleId());
                    continue;
                }
                this.delete(roleMoudle.getId());
            }
            if (CommonUtils.notEmpty(moudleIds)) {
                Integer[] integerArray = moudleIds;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int moudleId = integerArray[i];
                    this.save(new SysRoleMoudle(new SysRoleMoudleId(roleId, moudleId)));
                }
            }
        }
    }

    @Transactional(readOnly=true)
    public List<SysRoleMoudle> getEntitys(Integer[] roleIds, Integer[] moudleIds) {
        return this.dao.getEntitys(roleIds, moudleIds);
    }

    @Transactional(readOnly=true)
    public SysRoleMoudle getEntity(Integer[] roleIds, Integer moudleId) {
        return this.dao.getEntity(roleIds, moudleId);
    }

    public int deleteByRoleId(Integer roleId) {
        return this.dao.deleteByRoleId(roleId);
    }

    public int deleteByMoudleId(Integer moudleId) {
        return this.dao.deleteByMoudleId(moudleId);
    }
}

