/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.sys;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.publiccms.entities.sys.SysMoudle;
import org.publiccms.entities.sys.SysRoleAuthorized;
import org.publiccms.entities.sys.SysRoleAuthorizedId;
import org.publiccms.logic.dao.sys.SysRoleAuthorizedDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysRoleAuthorizedService
extends BaseService<SysRoleAuthorized> {
    @Autowired
    private SysRoleAuthorizedDao dao;

    @Transactional(readOnly=true)
    public PageHandler getPage(Integer roleId, String url, Integer pageIndex, Integer pageSize) {
        return this.dao.getPage(roleId, url, pageIndex, pageSize);
    }

    public int deleteByRoleId(Integer roleId) {
        return this.dao.deleteByRoleId(roleId);
    }

    public void dealRoleMoudles(Integer roleId, boolean showAllMoudle, List<SysMoudle> moudles, Set<String> pageUrls) {
        if (CommonUtils.notEmpty(roleId)) {
            HashSet<String> urls = new HashSet<String>();
            if (CommonUtils.notEmpty(moudles)) {
                for (SysMoudle moudle : moudles) {
                    if (CommonUtils.notEmpty(moudle.getUrl()) && !showAllMoudle) {
                        int index = moudle.getUrl().indexOf("?");
                        urls.add(moudle.getUrl().substring(0, index > 0 ? index : moudle.getUrl().length()));
                    }
                    if (!CommonUtils.notEmpty(moudle.getAuthorizedUrl())) continue;
                    for (String url : StringUtils.split((String)moudle.getAuthorizedUrl(), (char)',')) {
                        urls.add(url);
                    }
                }
            }
            if (showAllMoudle) {
                urls.addAll(pageUrls);
            }
            List<?> list = this.getPage(roleId, null, null, null).getList();
            for (SysRoleAuthorized roleAuthorized : list) {
                if (urls.contains(roleAuthorized.getId().getUrl())) {
                    urls.remove(roleAuthorized.getId().getUrl());
                    continue;
                }
                this.delete(roleAuthorized.getId());
            }
            if (!urls.isEmpty()) {
                for (String url : urls) {
                    this.save(new SysRoleAuthorized(new SysRoleAuthorizedId(roleId, url)));
                }
            }
        }
    }

    @Transactional(readOnly=true)
    public int count(String roleIds, String url) {
        String[] roleIdArray = StringUtils.split((String)roleIds, (char)',');
        if (CommonUtils.notEmpty(roleIds) && 0 < roleIdArray.length) {
            Integer[] intRoleIds = new Integer[roleIdArray.length];
            for (int i = 0; i < roleIdArray.length; ++i) {
                intRoleIds[i] = Integer.parseInt(roleIdArray[i]);
            }
            return this.dao.count(intRoleIds, url);
        }
        return 0;
    }
}

