/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.sys;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.tools.CommonUtils;
import java.util.HashSet;
import java.util.List;
import org.publiccms.entities.sys.SysExtendField;
import org.publiccms.logic.dao.sys.SysExtendFieldDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysExtendFieldService
extends BaseService<SysExtendField> {
    private String[] ignoreProperties = new String[]{"id"};
    @Autowired
    private SysExtendFieldDao dao;

    @Transactional(readOnly=true)
    public List<SysExtendField> getList(Integer extendId) {
        return this.dao.getList(extendId);
    }

    public void update(Integer extendId, List<SysExtendField> entitys) {
        if (CommonUtils.notEmpty(extendId)) {
            HashSet<String> codeList = new HashSet<String>();
            if (CommonUtils.notEmpty(entitys)) {
                for (SysExtendField entity : entitys) {
                    if (CommonUtils.notEmpty(entity.getId().getExtendId())) {
                        this.update(entity.getId(), entity, this.ignoreProperties);
                    } else {
                        entity.getId().setExtendId(extendId);
                        this.save(entity);
                    }
                    codeList.add(entity.getId().getCode());
                }
            }
            for (SysExtendField extend : this.getList(extendId)) {
                if (codeList.contains(extend.getId().getCode())) continue;
                this.delete(extend.getId());
            }
        }
    }
}

