/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.sys;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.publiccms.entities.sys.SysDeptCategory;
import org.publiccms.entities.sys.SysDeptPage;
import org.publiccms.entities.sys.SysDeptPageId;
import org.publiccms.logic.dao.sys.SysDeptPageDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysDeptPageService
extends BaseService<SysDeptPage> {
    @Autowired
    private SysDeptPageDao dao;

    @Transactional(readOnly=true)
    public PageHandler getPage(Integer deptId, String page, Integer pageIndex, Integer pageSize) {
        return this.dao.getPage(deptId, page, pageIndex, pageSize);
    }

    public void updateDeptPages(Integer deptId, String[] pages) {
        if (CommonUtils.notEmpty(deptId)) {
            List<?> list = this.getPage(deptId, null, null, null).getList();
            for (SysDeptPage deptPage : list) {
                if (ArrayUtils.contains((Object[])pages, (Object)deptPage.getId().getPage())) {
                    pages = (String[])ArrayUtils.removeElement((Object[])pages, (Object)deptPage.getId().getPage());
                    continue;
                }
                this.delete(deptPage.getId());
            }
            if (CommonUtils.notEmpty(pages)) {
                for (String page : pages) {
                    this.save(new SysDeptPage(new SysDeptPageId(deptId, page)));
                }
            }
        }
    }

    public void delete(Integer deptId, String page) {
        if (CommonUtils.notEmpty(page) || CommonUtils.notEmpty(deptId)) {
            List<?> list = this.getPage(deptId, page, null, null).getList();
            for (SysDeptCategory deptCategory : list) {
                this.delete(deptCategory.getId());
            }
        }
    }
}

