/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.sys;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.publiccms.entities.sys.SysDeptCategory;
import org.publiccms.entities.sys.SysDeptCategoryId;
import org.publiccms.logic.dao.sys.SysDeptCategoryDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysDeptCategoryService
extends BaseService<SysDeptCategory> {
    @Autowired
    private SysDeptCategoryDao dao;

    @Transactional(readOnly=true)
    public PageHandler getPage(Integer deptId, Integer categoryId, Integer pageIndex, Integer pageSize) {
        return this.dao.getPage(deptId, categoryId, pageIndex, pageSize);
    }

    public void updateDeptCategorys(Integer deptId, Integer[] categoryIds) {
        if (CommonUtils.notEmpty(deptId)) {
            List<?> list = this.getPage(deptId, null, null, null).getList();
            for (SysDeptCategory deptCategory : list) {
                if (ArrayUtils.contains((Object[])categoryIds, (Object)deptCategory.getId().getCategoryId())) {
                    categoryIds = (Integer[])ArrayUtils.removeElement((Object[])categoryIds, (Object)deptCategory.getId().getCategoryId());
                    continue;
                }
                this.delete(deptCategory.getId());
            }
            if (CommonUtils.notEmpty(categoryIds)) {
                for (Integer categoryId : categoryIds) {
                    this.save(new SysDeptCategory(new SysDeptCategoryId(deptId, categoryId)));
                }
            }
        }
    }

    public void delete(Integer deptId, Integer categoryId) {
        if (CommonUtils.notEmpty(categoryId) || CommonUtils.notEmpty(deptId)) {
            List<?> list = this.getPage(deptId, categoryId, null, null).getList();
            for (SysDeptCategory deptCategory : list) {
                this.delete(deptCategory.getId());
            }
        }
    }
}

