/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.cms;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.handler.PageHandler;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import org.publiccms.entities.cms.CmsWord;
import org.publiccms.logic.dao.cms.CmsWordDao;
import org.publiccms.views.pojo.CmsWordStatistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CmsWordService
extends BaseService<CmsWord> {
    @Autowired
    private CmsWordDao dao;

    @Transactional(readOnly=true)
    public PageHandler getPage(Integer siteId, Boolean hidden, Date startCreateDate, Date endCreateDate, String name, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        return this.dao.getPage(siteId, hidden, startCreateDate, endCreateDate, name, orderField, orderType, pageIndex, pageSize);
    }

    public void updateStatistics(Collection<CmsWordStatistics> entitys) {
        for (CmsWordStatistics entityStatistics : entitys) {
            CmsWord entity = (CmsWord)this.getEntity(Long.valueOf(entityStatistics.getId()));
            if (null == entity) continue;
            entity.setSearchCount(entity.getSearchCount() + entityStatistics.getSearchCounts());
        }
    }

    public CmsWord getEntity(int siteId, String name) {
        return this.dao.getEntity(siteId, name);
    }

    public CmsWord updateStatus(Serializable id, boolean status) {
        CmsWord entity = (CmsWord)this.getEntity(id);
        if (null != entity) {
            entity.setHidden(status);
        }
        return entity;
    }
}

