/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.cms;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.publiccms.entities.cms.CmsTagType;
import org.publiccms.logic.dao.cms.CmsTagTypeDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CmsTagTypeService
extends BaseService<CmsTagType> {
    @Autowired
    private CmsTagTypeDao dao;

    @Transactional(readOnly=true)
    public PageHandler getPage(Integer siteId, String name, Integer pageIndex, Integer pageSize) {
        return this.dao.getPage(siteId, name, pageIndex, pageSize);
    }

    public void delete(int siteId, Serializable[] ids) {
        for (CmsTagType entity : this.getEntitys(ids)) {
            if (siteId != entity.getSiteId()) continue;
            this.delete(entity.getId());
        }
    }

    public Integer[] update(int siteId, List<CmsTagType> entitys) {
        HashSet<Integer> idList = new HashSet<Integer>();
        if (CommonUtils.notEmpty(entitys)) {
            for (CmsTagType entity : entitys) {
                if (null != entity.getId()) {
                    if (siteId != (entity = (CmsTagType)this.getEntity(entity.getId())).getSiteId()) continue;
                    idList.add(entity.getId());
                    continue;
                }
                entity.setSiteId(siteId);
                this.save(entity);
                idList.add(entity.getId());
            }
        }
        return idList.toArray(new Integer[idList.size()]);
    }
}

