/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.cms;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.publiccms.entities.cms.CmsTag;
import org.publiccms.logic.dao.cms.CmsTagDao;
import org.publiccms.views.pojo.CmsTagStatistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CmsTagService
extends BaseService<CmsTag> {
    @Autowired
    private CmsTagDao dao;

    @Transactional(readOnly=true)
    public PageHandler getPage(Integer siteId, Integer typeId, String name, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        return this.dao.getPage(siteId, typeId, name, orderField, orderType, pageIndex, pageSize);
    }

    public void delete(int siteId, Serializable[] ids) {
        for (CmsTag entity : this.getEntitys(ids)) {
            if (siteId != entity.getSiteId()) continue;
            this.delete(entity.getId());
        }
    }

    public void updateStatistics(Collection<CmsTagStatistics> entitys) {
        for (CmsTagStatistics entityStatistics : entitys) {
            CmsTag entity = (CmsTag)this.getEntity(Long.valueOf(entityStatistics.getId()));
            if (null == entity) continue;
            entity.setSearchCount(entity.getSearchCount() + entityStatistics.getSearchCounts());
        }
    }

    public Long[] update(int siteId, List<CmsTag> entitys) {
        HashSet<Long> idList = new HashSet<Long>();
        if (CommonUtils.notEmpty(entitys)) {
            for (CmsTag entity : entitys) {
                if (null != entity.getId()) {
                    if (siteId != (entity = (CmsTag)this.getEntity(entity.getId())).getSiteId()) continue;
                    idList.add(entity.getId());
                    continue;
                }
                entity.setSiteId(siteId);
                this.save(entity);
                idList.add(entity.getId());
            }
        }
        return idList.toArray(new Long[idList.size()]);
    }
}

