/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.cms;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import org.publiccms.entities.cms.CmsPlace;
import org.publiccms.logic.dao.cms.CmsPlaceDao;
import org.publiccms.views.pojo.CmsPlaceStatistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CmsPlaceService
extends BaseService<CmsPlace> {
    public static final int STATUS_CONTRIBUTE = 0;
    public static final int STATUS_NORMAL = 1;
    public static final String ITEM_TYPE_CONTENT = "content";
    public static final String ITEM_TYPE_CATEGORY = "category";
    public static final String ITEM_TYPE_CUSTOM = "custom";
    @Autowired
    private CmsPlaceDao dao;

    @Transactional(readOnly=true)
    public PageHandler getPage(Integer siteId, Long userId, String path, String itemType, Integer itemId, Date startPublishDate, Date endPublishDate, Integer status, Boolean disabled, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        return this.dao.getPage(siteId, userId, path, itemType, itemId, startPublishDate, endPublishDate, status, disabled, orderField, orderType, pageIndex, pageSize);
    }

    public void updateStatistics(Collection<CmsPlaceStatistics> entitys) {
        for (CmsPlaceStatistics entityStatistics : entitys) {
            CmsPlace entity = (CmsPlace)this.getEntity(Long.valueOf(entityStatistics.getId()));
            if (null == entity) continue;
            entity.setClicks(entity.getClicks() + entityStatistics.getClicks());
        }
    }

    public void check(Serializable id) {
        CmsPlace entity = (CmsPlace)this.getEntity(id);
        if (null != entity) {
            entity.setStatus(1);
            Date now = CommonUtils.getDate();
            if (now.after(entity.getPublishDate())) {
                entity.setPublishDate(now);
            }
        }
    }

    public void check(int siteId, Serializable[] ids) {
        Date now = CommonUtils.getDate();
        for (CmsPlace entity : this.getEntitys(ids)) {
            if (siteId != entity.getSiteId() || 0 != entity.getStatus()) continue;
            entity.setStatus(1);
            if (!now.after(entity.getPublishDate())) continue;
            entity.setPublishDate(now);
        }
    }

    public void refresh(int siteId, Serializable[] ids) {
        Date now = CommonUtils.getDate();
        for (CmsPlace entity : this.getEntitys(ids)) {
            if (null == entity || 1 != entity.getStatus() || siteId != entity.getSiteId() || !now.after(entity.getPublishDate())) continue;
            entity.setPublishDate(now);
        }
    }

    @Override
    public void delete(Serializable id) {
        CmsPlace entity = (CmsPlace)this.getEntity(id);
        if (null != entity) {
            entity.setDisabled(true);
        }
    }

    public void delete(int siteId, Serializable[] ids) {
        for (CmsPlace entity : this.getEntitys(ids)) {
            if (siteId != entity.getSiteId() || entity.isDisabled()) continue;
            entity.setDisabled(true);
        }
    }

    public int delete(int siteId, String path) {
        return this.dao.delete(siteId, path);
    }
}

