/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.cms;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.tools.CommonUtils;
import java.util.HashSet;
import java.util.List;
import org.publiccms.entities.cms.CmsDictionaryData;
import org.publiccms.entities.cms.CmsDictionaryDataId;
import org.publiccms.logic.dao.cms.CmsDictionaryDataDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CmsDictionaryDataService
extends BaseService<CmsDictionaryData> {
    @Autowired
    private CmsDictionaryDataDao dao;

    public void save(Long dictionaryId, List<CmsDictionaryData> dataList) {
        if (CommonUtils.notEmpty(dataList)) {
            for (CmsDictionaryData entity : dataList) {
                if (null == entity.getId()) continue;
                entity.getId().setDictionaryId(dictionaryId);
                this.save(entity);
            }
        }
    }

    public void update(Long dictionaryId, List<CmsDictionaryData> dataList) {
        HashSet<CmsDictionaryDataId> idSet = new HashSet<CmsDictionaryDataId>();
        if (CommonUtils.notEmpty(dataList)) {
            for (CmsDictionaryData entity : dataList) {
                if (null == entity.getId()) continue;
                entity.getId().setDictionaryId(dictionaryId);
                CmsDictionaryData oldentity = (CmsDictionaryData)this.getEntity(entity.getId());
                if (CommonUtils.empty(oldentity)) {
                    this.save(entity);
                } else {
                    oldentity.setText(entity.getText());
                }
                idSet.add(entity.getId());
            }
        }
        List<CmsDictionaryData> list = this.getList(dictionaryId);
        for (CmsDictionaryData entity : list) {
            if (idSet.contains(entity.getId())) continue;
            this.delete(entity.getId());
        }
    }

    @Transactional(readOnly=true)
    public List<CmsDictionaryData> getList(long dictionaryId) {
        return this.dao.getList(dictionaryId);
    }
}

