/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.cms;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.handler.FacetPageHandler;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.publiccms.entities.cms.CmsCategory;
import org.publiccms.entities.cms.CmsContent;
import org.publiccms.logic.dao.cms.CmsCategoryDao;
import org.publiccms.logic.dao.cms.CmsContentDao;
import org.publiccms.views.pojo.CmsContentStatistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CmsContentService
extends BaseService<CmsContent> {
    public static final int STATUS_DRAFT = 0;
    public static final int STATUS_NORMAL = 1;
    public static final int STATUS_PEND = 2;
    @Autowired
    private CmsContentDao dao;
    @Autowired
    private CmsCategoryDao categoryDao;

    @Transactional(readOnly=true)
    public PageHandler query(Integer siteId, String text, String tagId, Integer pageIndex, Integer pageSize) {
        return this.dao.query(siteId, text, tagId, pageIndex, pageSize);
    }

    @Transactional(readOnly=true)
    public FacetPageHandler facetQuery(Integer siteId, String[] categoryIds, String[] modelIds, String[] userIds, String text, String tagId, Integer pageIndex, Integer pageSize) {
        return this.dao.facetQuery(siteId, categoryIds, modelIds, userIds, text, tagId, pageIndex, pageSize);
    }

    public void index(int siteId, Serializable[] ids) {
        this.dao.index(siteId, ids);
    }

    public Future<?> reCreateIndex() {
        return this.dao.reCreateIndex();
    }

    @Transactional(readOnly=true)
    public PageHandler getPage(Integer siteId, Integer[] status, Integer categoryId, Boolean containChild, Integer[] categoryIds, Boolean disabled, String[] modelIds, Long parentId, Boolean emptyParent, Boolean onlyUrl, Boolean hasImages, Boolean hasFiles, String title, Long userId, Long checkUserId, Date startPublishDate, Date endPublishDate, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        return this.dao.getPage(siteId, status, categoryId, this.getCategoryIds(containChild, categoryId, categoryIds), disabled, modelIds, parentId, emptyParent, onlyUrl, hasImages, hasFiles, title, userId, checkUserId, startPublishDate, endPublishDate, orderField, orderType, pageIndex, pageSize);
    }

    public void refresh(int siteId, Serializable[] ids) {
        for (CmsContent entity : this.getEntitys(ids)) {
            Date now;
            if (null == entity || 1 != entity.getStatus() || siteId != entity.getSiteId() || !(now = CommonUtils.getDate()).after(entity.getPublishDate())) continue;
            entity.setPublishDate(now);
        }
    }

    public List<CmsContent> check(int siteId, Long userId, Serializable[] ids) {
        ArrayList<CmsContent> entityList = new ArrayList<CmsContent>();
        for (CmsContent entity : this.getEntitys(ids)) {
            if (null == entity || siteId != entity.getSiteId() || 2 != entity.getStatus()) continue;
            entity.setStatus(1);
            entity.setCheckUserId(userId);
            entityList.add(entity);
        }
        return entityList;
    }

    public CmsContent updateTagIds(Serializable id, String tagIds) {
        CmsContent entity = (CmsContent)this.getEntity(id);
        if (null != entity) {
            entity.setTagIds(tagIds);
        }
        return entity;
    }

    public void updateStatistics(Collection<CmsContentStatistics> entitys) {
        for (CmsContentStatistics entityStatistics : entitys) {
            CmsContent entity = (CmsContent)this.getEntity(Long.valueOf(entityStatistics.getId()));
            if (null == entity) continue;
            entity.setClicks(entity.getClicks() + entityStatistics.getClicks());
            entity.setComments(entity.getComments() + entityStatistics.getComments());
            entity.setScores(entity.getScores() + entityStatistics.getScores());
        }
    }

    public CmsContent updateCategoryId(int siteId, Serializable id, int categoryId) {
        CmsContent entity = (CmsContent)this.getEntity(id);
        if (null != entity && siteId == entity.getSiteId()) {
            entity.setCategoryId(categoryId);
        }
        return entity;
    }

    public CmsContent updateChilds(Serializable id, int num) {
        CmsContent entity = (CmsContent)this.getEntity(id);
        if (null != entity) {
            entity.setChilds(entity.getChilds() + num);
        }
        return entity;
    }

    public CmsContent sort(Integer siteId, Long id, int sort) {
        CmsContent entity = (CmsContent)this.getEntity(id);
        if (null != entity && siteId.intValue() == entity.getSiteId()) {
            entity.setSort(sort);
        }
        return entity;
    }

    public CmsContent updateUrl(Serializable id, String url, boolean hasStatic) {
        CmsContent entity = (CmsContent)this.getEntity(id);
        if (null != entity) {
            entity.setUrl(url);
            entity.setHasStatic(hasStatic);
        }
        return entity;
    }

    public int deleteByCategoryIds(int siteId, Integer[] categoryIds) {
        return this.dao.deleteByCategoryIds(siteId, categoryIds);
    }

    public List<CmsContent> delete(int siteId, Serializable[] ids) {
        ArrayList<CmsContent> entityList = new ArrayList<CmsContent>();
        for (CmsContent entity : this.getEntitys(ids)) {
            if (siteId != entity.getSiteId() || entity.isDisabled()) continue;
            if (0 < entity.getChilds()) {
                for (CmsContent child : this.getPage(siteId, null, null, null, null, false, null, entity.getId(), null, null, null, null, null, null, null, null, null, null, null, null, null).getList()) {
                    child.setDisabled(true);
                    entityList.add(child);
                }
            }
            entity.setDisabled(true);
            entityList.add(entity);
        }
        return entityList;
    }

    private Integer[] getCategoryIds(Boolean containChild, Integer categoryId, Integer[] categoryIds) {
        CmsCategory category;
        if (CommonUtils.empty(categoryId)) {
            return categoryIds;
        }
        if (CommonUtils.notEmpty(containChild) && containChild.booleanValue() && null != (category = (CmsCategory)this.categoryDao.getEntity(categoryId)) && CommonUtils.notEmpty(category.getChildIds())) {
            String[] categoryStringIds = (String[])ArrayUtils.add((Object[])StringUtils.splitByWholeSeparator((String)category.getChildIds(), (String)","), (Object)String.valueOf(categoryId));
            categoryIds = new Integer[categoryStringIds.length + 1];
            for (int i = 0; i < categoryStringIds.length; ++i) {
                categoryIds[i] = Integer.parseInt(categoryStringIds[i]);
            }
            categoryIds[categoryStringIds.length] = categoryId;
        }
        return categoryIds;
    }

    public List<CmsContent> recycle(int siteId, Serializable[] ids) {
        ArrayList<CmsContent> entityList = new ArrayList<CmsContent>();
        for (CmsContent entity : this.getEntitys(ids)) {
            if (siteId != entity.getSiteId() || !entity.isDisabled()) continue;
            if (0 < entity.getChilds()) {
                for (CmsContent child : this.getPage(siteId, null, null, null, null, false, null, entity.getId(), null, null, null, null, null, null, null, null, null, null, null, null, null).getList()) {
                    child.setDisabled(false);
                    entityList.add(child);
                }
            }
            entity.setDisabled(false);
            entityList.add(entity);
        }
        return entityList;
    }

    public List<CmsContent> realDelete(Integer siteId, Long[] ids) {
        ArrayList<CmsContent> entityList = new ArrayList<CmsContent>();
        for (CmsContent entity : this.getEntitys(ids)) {
            if (siteId.intValue() != entity.getSiteId() || !entity.isDisabled()) continue;
            if (0 < entity.getChilds()) {
                for (CmsContent child : this.getPage(siteId, null, null, null, null, false, null, entity.getId(), null, null, null, null, null, null, null, null, null, null, null, null, null).getList()) {
                    this.delete(child.getId());
                }
            }
            this.delete(entity.getId());
        }
        return entityList;
    }
}

