/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.cms;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.publiccms.entities.cms.CmsContentRelated;
import org.publiccms.logic.dao.cms.CmsContentRelatedDao;
import org.publiccms.views.pojo.CmsContentRelatedStatistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CmsContentRelatedService
extends BaseService<CmsContentRelated> {
    private String[] ignoreProperties = new String[]{"id", "contentId", "userId"};
    @Autowired
    private CmsContentRelatedDao dao;

    @Transactional(readOnly=true)
    public PageHandler getPage(Long contentId, Long relatedContentId, Long userId, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        return this.dao.getPage(contentId, relatedContentId, userId, orderField, orderType, pageIndex, pageSize);
    }

    public void updateStatistics(Collection<CmsContentRelatedStatistics> entitys) {
        for (CmsContentRelatedStatistics entityStatistics : entitys) {
            CmsContentRelated entity = (CmsContentRelated)this.getEntity(Long.valueOf(entityStatistics.getId()));
            if (null == entity) continue;
            entity.setClicks(entity.getClicks() + entityStatistics.getClicks());
        }
    }

    public void update(long contentId, long userId, List<CmsContentRelated> entitys) {
        HashSet<Long> idList = new HashSet<Long>();
        if (CommonUtils.notEmpty(entitys)) {
            for (CmsContentRelated entity : entitys) {
                if (null != entity.getId()) {
                    this.update(entity.getId(), entity, this.ignoreProperties);
                } else {
                    entity.setContentId(contentId);
                    entity.setUserId(userId);
                    this.save(entity);
                }
                idList.add(entity.getId());
            }
        }
        for (CmsContentRelated extend : this.getPage(contentId, null, null, null, null, null, null).getList()) {
            if (idList.contains(extend.getId())) continue;
            this.delete(extend.getId());
        }
    }
}

