/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.cms;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.HashSet;
import java.util.List;
import org.publiccms.entities.cms.CmsContentFile;
import org.publiccms.logic.dao.cms.CmsContentFileDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CmsContentFileService
extends BaseService<CmsContentFile> {
    private String[] ignoreProperties = new String[]{"id", "userId", "contentId", "image"};
    @Autowired
    private CmsContentFileDao dao;

    @Transactional(readOnly=true)
    public PageHandler getPage(Long contentId, Long userId, Boolean image, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        return this.dao.getPage(contentId, userId, image, orderField, orderType, pageIndex, pageSize);
    }

    public void update(long contentId, Long userId, List<CmsContentFile> files, List<CmsContentFile> images) {
        HashSet<Long> idList = new HashSet<Long>();
        if (CommonUtils.notEmpty(images)) {
            for (CmsContentFile entity : images) {
                if (null != entity.getId()) {
                    this.update(entity.getId(), entity, this.ignoreProperties);
                } else {
                    entity.setImage(true);
                    entity.setUserId(userId);
                    entity.setContentId(contentId);
                    this.save(entity);
                }
                idList.add(entity.getId());
            }
        }
        if (CommonUtils.notEmpty(files)) {
            for (CmsContentFile entity : files) {
                if (null != entity.getId()) {
                    this.update(entity.getId(), entity, this.ignoreProperties);
                } else {
                    entity.setContentId(contentId);
                    entity.setUserId(userId);
                    this.save(entity);
                }
                idList.add(entity.getId());
            }
        }
        for (CmsContentFile extend : this.getPage(contentId, null, null, null, null, null, null).getList()) {
            if (idList.contains(extend.getId())) continue;
            this.delete(extend.getId());
        }
    }
}

