/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.service.cms;

import com.publiccms.common.base.BaseService;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.Serializable;
import java.util.List;
import org.publiccms.entities.cms.CmsCategory;
import org.publiccms.logic.dao.cms.CmsCategoryDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CmsCategoryService
extends BaseService<CmsCategory> {
    @Autowired
    private CmsCategoryDao dao;

    @Transactional(readOnly=true)
    public PageHandler getPage(Integer siteId, Integer parentId, Boolean queryAll, Integer typeId, Boolean allowContribute, Boolean hidden, Boolean disabled, Integer pageIndex, Integer pageSize) {
        return this.dao.getPage(siteId, parentId, queryAll, typeId, allowContribute, hidden, disabled, pageIndex, pageSize);
    }

    public void addChildIds(Serializable parentId, Serializable id) {
        CmsCategory parent;
        if (null != parentId && null != (parent = (CmsCategory)this.getEntity(parentId))) {
            this.addChildIds(parent.getParentId(), id);
            String childIds = CommonUtils.notEmpty(parent.getChildIds()) ? parent.getChildIds() + "," + String.valueOf(id) : String.valueOf(id);
            this.updateChildIds(parent.getId(), childIds);
        }
    }

    public void changeType(Integer id, Integer typeId) {
        CmsCategory entity = (CmsCategory)this.getEntity(id);
        if (null != entity) {
            entity.setTypeId(typeId);
        }
    }

    private String getChildIds(int siteId, Integer parentId) {
        StringBuilder childIds = new StringBuilder();
        List<?> list = this.getPage(siteId, parentId, false, null, null, null, false, null, null).getList();
        if (0 < list.size()) {
            for (CmsCategory category : list) {
                childIds.append(category.getId());
                childIds.append(",");
                String childChildIds = this.getChildIds(siteId, category.getId());
                if (!CommonUtils.notEmpty(childChildIds)) continue;
                childIds.append(childChildIds);
                childIds.append(",");
            }
            if (0 < childIds.length()) {
                childIds.setLength(childIds.length() - 1);
            }
        }
        if (0 < childIds.length()) {
            return childIds.toString();
        }
        return null;
    }

    public void generateChildIds(int siteId, Integer parentId) {
        if (null != parentId) {
            this.updateChildIds(parentId, this.getChildIds(siteId, parentId));
            CmsCategory parent = (CmsCategory)this.getEntity(parentId);
            if (null != parent) {
                this.generateChildIds(siteId, parent.getParentId());
            }
        }
    }

    public void delete(int siteId, Integer[] ids) {
        for (CmsCategory entity : this.getEntitys(ids)) {
            if (siteId != entity.getSiteId() || entity.isDisabled()) continue;
            List<?> list = this.getPage(siteId, entity.getId(), false, null, null, null, null, null, null).getList();
            for (CmsCategory child : list) {
                child.setParentId(entity.getParentId());
            }
            entity.setDisabled(true);
            this.generateChildIds(entity.getSiteId(), entity.getParentId());
        }
    }

    public void updateChildIds(Serializable id, String childIds) {
        CmsCategory entity = (CmsCategory)this.getEntity(id);
        if (null != entity) {
            entity.setChildIds(childIds);
        }
    }

    public void updateTagTypeIds(Serializable id, String tagTypeIds) {
        CmsCategory entity = (CmsCategory)this.getEntity(id);
        if (null != entity) {
            entity.setTagTypeIds(tagTypeIds);
        }
    }

    public CmsCategory updateExtendId(Integer id, Integer extendId) {
        CmsCategory entity = (CmsCategory)this.getEntity(id);
        if (null != entity) {
            entity.setExtendId(extendId);
        }
        return entity;
    }

    public void updateParentId(int siteId, Serializable id, Integer parentId) {
        CmsCategory entity = (CmsCategory)this.getEntity(id);
        if (null != entity && siteId == entity.getSiteId()) {
            entity.setParentId(parentId);
        }
    }

    public void updateUrl(Serializable id, String url, boolean hasStatic) {
        CmsCategory entity = (CmsCategory)this.getEntity(id);
        if (null != entity) {
            entity.setUrl(url);
            entity.setHasStatic(hasStatic);
        }
    }

    public void updateContents(Serializable id, int num) {
        CmsCategory entity = (CmsCategory)this.getEntity(id);
        if (null != entity) {
            entity.setContents(entity.getContents() + num);
        }
    }
}

