/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.tools;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.springframework.stereotype.Repository;

@Repository
public class HqlDao
extends BaseDao<Object> {
    public PageHandler getPage(String hql, Map<String, Object> paramters, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = HqlDao.getQueryHandler(hql);
        if (CommonUtils.notEmpty(paramters)) {
            for (Map.Entry<String, Object> entry : paramters.entrySet()) {
                queryHandler.setParameter(entry.getKey(), entry.getValue());
            }
        }
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    public int update(String hql) {
        QueryHandler queryHandler = HqlDao.getQueryHandler(hql);
        return this.update(queryHandler);
    }

    public int delete(String hql) {
        QueryHandler queryHandler = HqlDao.getDeleteQueryHandler(hql);
        return this.delete(queryHandler);
    }

    public Analyzer getAnalyzer() {
        return super.getFullTextSession().getSearchFactory().getAnalyzer("default");
    }

    @Override
    protected Object init(Object entity) {
        return entity;
    }

    public void clear() {
        this.sessionFactory.getCache().evictAllRegions();
    }
}

