/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.sys;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.Date;
import org.publiccms.entities.sys.SysUserToken;
import org.springframework.stereotype.Repository;

@Repository
public class SysUserTokenDao
extends BaseDao<SysUserToken> {
    public PageHandler getPage(Integer siteId, Long userId, String channel, String orderType, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = SysUserTokenDao.getQueryHandler("from SysUserToken bean");
        if (CommonUtils.notEmpty(siteId)) {
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        }
        if (CommonUtils.notEmpty(userId)) {
            queryHandler.condition("bean.userId = :userId").setParameter("userId", userId);
        }
        if (CommonUtils.notEmpty(channel)) {
            queryHandler.condition("bean.channel = :channel").setParameter("channel", channel);
        }
        if (!"asc".equalsIgnoreCase(orderType)) {
            orderType = "desc";
        }
        queryHandler.order("bean.createDate " + orderType);
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    public int delete(Date createDate) {
        if (CommonUtils.notEmpty(createDate)) {
            QueryHandler queryHandler = SysUserTokenDao.getDeleteQueryHandler("from SysUserToken bean");
            queryHandler.condition("bean.createDate <= :createDate").setParameter("createDate", createDate);
            return this.delete(queryHandler);
        }
        return 0;
    }

    @Override
    protected SysUserToken init(SysUserToken entity) {
        if (CommonUtils.empty(entity.getCreateDate())) {
            entity.setCreateDate(CommonUtils.getDate());
        }
        return entity;
    }
}

