/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.sys;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.Date;
import org.publiccms.entities.sys.SysUser;
import org.springframework.stereotype.Repository;

@Repository
public class SysUserDao
extends BaseDao<SysUser> {
    public PageHandler getPage(Integer siteId, Integer deptId, Date startRegisteredDate, Date endRegisteredDate, Date startLastLoginDate, Date endLastLoginDate, Boolean superuserAccess, Boolean emailChecked, Boolean disabled, String name, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = SysUserDao.getQueryHandler("from SysUser bean");
        if (CommonUtils.notEmpty(siteId)) {
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        }
        if (CommonUtils.notEmpty(deptId)) {
            queryHandler.condition("bean.deptId = :deptId").setParameter("deptId", deptId);
        }
        if (CommonUtils.notEmpty(startRegisteredDate)) {
            queryHandler.condition("bean.registeredDate > :startRegisteredDate").setParameter("startRegisteredDate", startRegisteredDate);
        }
        if (CommonUtils.notEmpty(endRegisteredDate)) {
            queryHandler.condition("bean.registeredDate <= :endRegisteredDate").setParameter("endRegisteredDate", SysUserDao.tomorrow(endRegisteredDate));
        }
        if (CommonUtils.notEmpty(startLastLoginDate)) {
            queryHandler.condition("bean.lastLoginDate > :startLastLoginDate").setParameter("startLastLoginDate", startLastLoginDate);
        }
        if (CommonUtils.notEmpty(endLastLoginDate)) {
            queryHandler.condition("bean.lastLoginDate <= :endLastLoginDate").setParameter("endLastLoginDate", SysUserDao.tomorrow(endLastLoginDate));
        }
        if (CommonUtils.notEmpty(superuserAccess)) {
            queryHandler.condition("bean.superuserAccess = :superuserAccess").setParameter("superuserAccess", superuserAccess);
        }
        if (CommonUtils.notEmpty(emailChecked)) {
            queryHandler.condition("bean.emailChecked = :emailChecked").setParameter("emailChecked", emailChecked);
        }
        if (CommonUtils.notEmpty(disabled)) {
            queryHandler.condition("bean.disabled = :disabled").setParameter("disabled", disabled);
        }
        if (CommonUtils.notEmpty(name)) {
            queryHandler.condition("(bean.name like :name or bean.nickName like :name or bean.email like :name)").setParameter("name", SysUserDao.like(name));
        }
        if (!"asc".equalsIgnoreCase(orderType)) {
            orderType = "desc";
        }
        if (null == orderField) {
            orderField = "";
        }
        switch (orderField) {
            case "lastLoginDate": {
                queryHandler.order("bean.lastLoginDate " + orderType);
                break;
            }
            case "loginCount": {
                queryHandler.order("bean.loginCount " + orderType);
                break;
            }
            case "registeredDate": {
                queryHandler.order("bean.registeredDate " + orderType);
                break;
            }
            default: {
                queryHandler.order("bean.id " + orderType);
            }
        }
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    public SysUser findByName(int siteId, String name) {
        QueryHandler queryHandler = SysUserDao.getQueryHandler("from SysUser bean");
        queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        queryHandler.condition("bean.name = :name").setParameter("name", name);
        return (SysUser)this.getEntity(queryHandler);
    }

    public SysUser findByNickName(int siteId, String nickname) {
        QueryHandler queryHandler = SysUserDao.getQueryHandler("from SysUser bean");
        queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        queryHandler.condition("bean.nickName = :nickname").setParameter("nickname", nickname);
        return (SysUser)this.getEntity(queryHandler);
    }

    public SysUser findByEmail(int siteId, String email) {
        QueryHandler queryHandler = SysUserDao.getQueryHandler("from SysUser bean");
        queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        queryHandler.condition("bean.email = :email and bean.emailChecked = :emailChecked").setParameter("email", email).setParameter("emailChecked", true);
        return (SysUser)this.getEntity(queryHandler);
    }

    @Override
    protected SysUser init(SysUser entity) {
        if (CommonUtils.empty(entity.getRegisteredDate())) {
            entity.setRegisteredDate(CommonUtils.getDate());
        }
        return entity;
    }
}

