/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.sys;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import org.publiccms.entities.sys.SysRoleUser;
import org.springframework.stereotype.Repository;

@Repository
public class SysRoleUserDao
extends BaseDao<SysRoleUser> {
    public PageHandler getPage(Integer roleId, Long userId, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = SysRoleUserDao.getQueryHandler("from SysRoleUser bean");
        if (CommonUtils.notEmpty(roleId)) {
            queryHandler.condition("bean.id.roleId = :roleId").setParameter("roleId", roleId);
        }
        if (CommonUtils.notEmpty(userId)) {
            queryHandler.condition("bean.id.userId = :userId").setParameter("userId", userId);
        }
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    public int deleteByRoleId(Integer roleId) {
        if (CommonUtils.notEmpty(roleId)) {
            QueryHandler queryHandler = SysRoleUserDao.getDeleteQueryHandler("from SysRoleUser bean where bean.id.roleId = :roleId");
            queryHandler.setParameter("roleId", roleId);
            return this.delete(queryHandler);
        }
        return 0;
    }

    public int deleteByUserId(Long userId) {
        if (CommonUtils.notEmpty(userId)) {
            QueryHandler queryHandler = SysRoleUserDao.getDeleteQueryHandler("from SysRoleUser bean where bean.id.userId = :userId");
            queryHandler.setParameter("userId", userId);
            return this.delete(queryHandler);
        }
        return 0;
    }

    @Override
    protected SysRoleUser init(SysRoleUser entity) {
        return entity;
    }
}

