/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.sys;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import org.publiccms.entities.sys.SysRoleAuthorized;
import org.springframework.stereotype.Repository;

@Repository
public class SysRoleAuthorizedDao
extends BaseDao<SysRoleAuthorized> {
    public PageHandler getPage(Integer roleId, String url, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = SysRoleAuthorizedDao.getQueryHandler("from SysRoleAuthorized bean");
        if (CommonUtils.notEmpty(roleId)) {
            queryHandler.condition("bean.id.roleId = :roleId").setParameter("roleId", roleId);
        }
        if (CommonUtils.notEmpty(url)) {
            queryHandler.condition("bean.id.url = :url").setParameter("url", url);
        }
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    public int count(Integer[] roleIds, String url) {
        QueryHandler queryHandler = SysRoleAuthorizedDao.getCountQueryHandler("from SysRoleAuthorized bean");
        if (CommonUtils.notEmpty(roleIds)) {
            queryHandler.condition("bean.id.roleId in (:roleIds)").setParameter("roleIds", roleIds);
        }
        if (CommonUtils.notEmpty(url)) {
            queryHandler.condition("bean.id.url = :url").setParameter("url", url);
        }
        return this.count(queryHandler);
    }

    public int deleteByRoleId(Integer roleId) {
        if (CommonUtils.notEmpty(roleId)) {
            QueryHandler queryHandler = SysRoleAuthorizedDao.getDeleteQueryHandler("from SysRoleAuthorized bean where bean.id.roleId = :roleId");
            queryHandler.setParameter("roleId", roleId);
            return this.delete(queryHandler);
        }
        return 0;
    }

    @Override
    protected SysRoleAuthorized init(SysRoleAuthorized entity) {
        return entity;
    }
}

