/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.sys;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.Date;
import org.publiccms.entities.sys.SysAppClient;
import org.springframework.stereotype.Repository;

@Repository
public class SysAppClientDao
extends BaseDao<SysAppClient> {
    public PageHandler getPage(Integer siteId, String channel, Long userId, Boolean allowPush, Date startLastLoginDate, Date endLastLoginDate, Date startCreateDate, Date endCreateDate, Boolean disabled, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = SysAppClientDao.getQueryHandler("from SysAppClient bean");
        if (CommonUtils.notEmpty(siteId)) {
            queryHandler.condition("bean.id.siteId = :siteId").setParameter("siteId", siteId);
        }
        if (CommonUtils.notEmpty(channel)) {
            queryHandler.condition("bean.id.channel = :channel").setParameter("channel", channel);
        }
        if (CommonUtils.notEmpty(userId)) {
            queryHandler.condition("bean.userId = :userId").setParameter("userId", userId);
        }
        if (CommonUtils.notEmpty(allowPush)) {
            queryHandler.condition("bean.allowPush = :allowPush").setParameter("allowPush", allowPush);
        }
        if (CommonUtils.notEmpty(startLastLoginDate)) {
            queryHandler.condition("bean.lastLoginDate > :startLastLoginDate").setParameter("startLastLoginDate", startLastLoginDate);
        }
        if (CommonUtils.notEmpty(endLastLoginDate)) {
            queryHandler.condition("bean.lastLoginDate <= :endLastLoginDate").setParameter("endLastLoginDate", endLastLoginDate);
        }
        if (CommonUtils.notEmpty(startCreateDate)) {
            queryHandler.condition("bean.createDate > :startCreateDate").setParameter("startCreateDate", startCreateDate);
        }
        if (CommonUtils.notEmpty(endCreateDate)) {
            queryHandler.condition("bean.createDate <= :endCreateDate").setParameter("endCreateDate", endCreateDate);
        }
        if (CommonUtils.notEmpty(disabled)) {
            queryHandler.condition("bean.disabled = :disabled").setParameter("disabled", disabled);
        }
        if (!"asc".equalsIgnoreCase(orderType)) {
            orderType = "desc";
        }
        if (null == orderField) {
            orderField = "";
        }
        switch (orderField) {
            case "lastLoginDate": {
                queryHandler.order("bean.lastLoginDate " + orderType);
                break;
            }
            case "createDate": {
                queryHandler.order("bean.createDate " + orderType);
                break;
            }
            default: {
                queryHandler.order("bean.createDate " + orderType);
            }
        }
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    @Override
    protected SysAppClient init(SysAppClient entity) {
        if (CommonUtils.empty(entity.getCreateDate())) {
            entity.setCreateDate(CommonUtils.getDate());
        }
        return entity;
    }
}

