/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.log;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.Date;
import org.publiccms.entities.log.LogUpload;
import org.springframework.stereotype.Repository;

@Repository
public class LogUploadDao
extends BaseDao<LogUpload> {
    public PageHandler getPage(Integer siteId, Long userId, String channel, Boolean image, String filePath, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = LogUploadDao.getQueryHandler("from LogUpload bean");
        if (CommonUtils.notEmpty(siteId)) {
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        }
        if (CommonUtils.notEmpty(userId)) {
            queryHandler.condition("bean.userId = :userId").setParameter("userId", userId);
        }
        if (CommonUtils.notEmpty(channel)) {
            queryHandler.condition("bean.channel = :channel").setParameter("channel", channel);
        }
        if (CommonUtils.notEmpty(image)) {
            queryHandler.condition("bean.image = :image").setParameter("image", image);
        }
        if (CommonUtils.notEmpty(filePath)) {
            queryHandler.condition("bean.filePath like :filePath").setParameter("content", LogUploadDao.like(filePath));
        }
        if (!"asc".equalsIgnoreCase(orderType)) {
            orderType = "desc";
        }
        if (null == orderField) {
            orderField = "";
        }
        switch (orderField) {
            case "createDate": {
                queryHandler.order("bean.createDate " + orderType);
                break;
            }
            case "fileSize": {
                queryHandler.order("bean.fileSize " + orderType);
                break;
            }
            default: {
                queryHandler.order("bean.id " + orderType);
            }
        }
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    public int delete(Integer siteId, Date createDate) {
        if (CommonUtils.notEmpty(siteId) || CommonUtils.notEmpty(createDate)) {
            QueryHandler queryHandler = LogUploadDao.getDeleteQueryHandler("from LogUpload bean");
            if (CommonUtils.notEmpty(siteId)) {
                queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
            }
            if (CommonUtils.notEmpty(createDate)) {
                queryHandler.condition("bean.createDate <= :createDate").setParameter("createDate", createDate);
            }
            return this.delete(queryHandler);
        }
        return 0;
    }

    @Override
    protected LogUpload init(LogUpload entity) {
        if (CommonUtils.empty(entity.getCreateDate())) {
            entity.setCreateDate(CommonUtils.getDate());
        }
        return entity;
    }
}

