/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.log;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.Date;
import org.publiccms.entities.log.LogTask;
import org.springframework.stereotype.Repository;

@Repository
public class LogTaskDao
extends BaseDao<LogTask> {
    public PageHandler getPage(Integer siteId, Integer taskId, Date startBegintime, Date endBegintime, Boolean success, String orderType, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = LogTaskDao.getQueryHandler("select new LogTask(id, siteId, taskId, begintime, endtime, success) from LogTask bean");
        if (CommonUtils.notEmpty(siteId)) {
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        }
        if (CommonUtils.notEmpty(taskId)) {
            queryHandler.condition("bean.taskId = :taskId").setParameter("taskId", taskId);
        }
        if (CommonUtils.notEmpty(startBegintime)) {
            queryHandler.condition("bean.begintime > :startBegintime").setParameter("startBegintime", startBegintime);
        }
        if (CommonUtils.notEmpty(endBegintime)) {
            queryHandler.condition("bean.begintime <= :endBegintime").setParameter("endBegintime", endBegintime);
        }
        if (CommonUtils.notEmpty(success)) {
            queryHandler.condition("bean.success = :success").setParameter("success", success);
        }
        if (!"asc".equalsIgnoreCase(orderType)) {
            orderType = "desc";
        }
        queryHandler.order("bean.begintime " + orderType);
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    public int delete(Integer siteId, Date begintime) {
        if (CommonUtils.notEmpty(siteId) || CommonUtils.notEmpty(begintime)) {
            QueryHandler queryHandler = LogTaskDao.getDeleteQueryHandler("from LogTask bean");
            if (CommonUtils.notEmpty(siteId)) {
                queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
            }
            if (CommonUtils.notEmpty(begintime)) {
                queryHandler.condition("bean.begintime <= :begintime").setParameter("begintime", begintime);
            }
            return this.delete(queryHandler);
        }
        return 0;
    }

    @Override
    protected LogTask init(LogTask entity) {
        if (CommonUtils.empty(entity.getBegintime())) {
            entity.setBegintime(CommonUtils.getDate());
        }
        return entity;
    }
}

