/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.log;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.Date;
import org.publiccms.entities.log.LogLogin;
import org.springframework.stereotype.Repository;

@Repository
public class LogLoginDao
extends BaseDao<LogLogin> {
    public PageHandler getPage(Integer siteId, Long userId, Date startCreateDate, Date endCreateDate, String channel, Boolean result, String name, String ip, String orderType, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = LogLoginDao.getQueryHandler("from LogLogin bean");
        if (CommonUtils.notEmpty(siteId)) {
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        }
        if (CommonUtils.notEmpty(userId)) {
            queryHandler.condition("bean.userId = :userId").setParameter("userId", userId);
        }
        if (CommonUtils.notEmpty(startCreateDate)) {
            queryHandler.condition("bean.createDate > :startCreateDate").setParameter("startCreateDate", startCreateDate);
        }
        if (CommonUtils.notEmpty(endCreateDate)) {
            queryHandler.condition("bean.createDate <= :endCreateDate").setParameter("endCreateDate", LogLoginDao.tomorrow(endCreateDate));
        }
        if (CommonUtils.notEmpty(channel)) {
            queryHandler.condition("bean.channel = :channel").setParameter("channel", channel);
        }
        if (CommonUtils.notEmpty(result)) {
            queryHandler.condition("bean.result = :result").setParameter("result", result);
        }
        if (CommonUtils.notEmpty(name)) {
            queryHandler.condition("bean.name like :name").setParameter("name", LogLoginDao.like(name));
        }
        if (CommonUtils.notEmpty(ip)) {
            queryHandler.condition("bean.ip like :ip").setParameter("ip", LogLoginDao.like(ip));
        }
        if (!"asc".equalsIgnoreCase(orderType)) {
            orderType = "desc";
        }
        queryHandler.order("bean.createDate " + orderType + ",bean.id " + orderType);
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    public int delete(Integer siteId, Date createDate) {
        if (CommonUtils.notEmpty(siteId) || CommonUtils.notEmpty(createDate)) {
            QueryHandler queryHandler = LogLoginDao.getDeleteQueryHandler("from LogLogin bean");
            if (CommonUtils.notEmpty(siteId)) {
                queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
            }
            if (CommonUtils.notEmpty(createDate)) {
                queryHandler.condition("bean.createDate <= :createDate").setParameter("createDate", createDate);
            }
            return this.delete(queryHandler);
        }
        return 0;
    }

    @Override
    protected LogLogin init(LogLogin entity) {
        if (CommonUtils.empty(entity.getCreateDate())) {
            entity.setCreateDate(CommonUtils.getDate());
        }
        return entity;
    }
}

